/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.MenuOption;
import Entity.Mouse;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Content;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class HowToPlayState
extends GameState {
    private Font font;
    private BufferedImage howToPlay;
    private MenuOption mo;
    private Mouse mouse;

    public HowToPlayState(GameStateManager gsm) {
        this.gsm = gsm;
        this.font = new Font("Arial", 0, 20);
        this.howToPlay = Content.HowToPlay;
        this.mo = new MenuOption("Back", gsm.regFont, 650, 300);
        this.mouse = new Mouse();
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)this.howToPlay, 0, 0, null);
        g.setFont(this.font);
        g.setColor(Color.WHITE);
        g.drawString("->  Use the arrow keys to control your ship around space", 50, 270);
        g.drawString("->  Use the space bar to shoot the comets and score points", 50, 300);
        g.drawString("->  Collect Power Up ammo to better help destroy the comets", 50, 330);
        g.drawString("->  Switch weapons with Q, W, E and R and press P to pause", 50, 360);
        g.drawString("->  Dont let the comets reach the end of the screen or hit you", 50, 390);
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mouse.draw(g);
        } else {
            g.setColor(Color.yellow);
            g.drawString("Back", 650, 300);
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK) && this.mo.getChoice() == 0) {
                this.gsm.setState(0);
            }
        } else if (Keys.isKeyPressed(Keys.ENTER)) {
            this.gsm.setState(0);
        }
    }
}

